#ifdef GL_ES
precision mediump float;

varying vec3 normal;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 normal;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform sampler2D normalTex;
uniform float brightness;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
    fragColor = vec4((brightness * tColor.rgb), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
